package com.ejie.ab04b.service;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.StringReader;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejie.ab04b.constantes.ConstantesDocumentos;
import com.ejie.ab04b.exception.AB04BException;
import com.ejie.ab04b.model.VdocOs6;
import com.ejie.ab04b.util.CaracteresRarosUtil;

@Service(value = "generacionPDFDocOS6Impl")
public class GeneracionPDFDocOS6Impl implements GeneracionPDFDocOS6Service {

	@Autowired
	private VdocOs6Service vdocOs6Service;

	/**
	 * Devuelve un InputStream con el documento pdf.
	 * 
	 *  folderNumber
	 *            String
	 *  numEje
	 *            Integer
	 *  Inputstream
	 *
	 * @param folderNumber the folder number
	 * @param numEje the num eje
	 * @return the pdf
	 * @throws AB04BException the AB 04 B exception
	 */
	public InputStream getPDF(String folderNumber, Integer numEje)
			throws AB04BException {
		String folderNumberAux = folderNumber;
		try {
			folderNumberAux = folderNumberAux.replaceAll("/", "-");
			String xslFichero = "";
			xslFichero = ConstantesDocumentos.DOC_OS6_XSL;

			InputStream inputStream = null;

			VdocOs6 vdocOs6 = new VdocOs6(folderNumberAux);
			vdocOs6.setNumeje(numEje);
			vdocOs6 = this.vdocOs6Service.find(vdocOs6);
			StringBuffer xmlPdf = getXml(vdocOs6);
			String xml = CaracteresRarosUtil.htmlEscape(xmlPdf.toString());
			StringReader xmlReader = new StringReader(xml);

			// Inicializo transformer
			Transformer transformer = pdfTransformacionInit(xslFichero);
			// Ejecuto transformación
			ByteArrayOutputStream byteOut = pdfTransformacionExec(transformer,
					xmlReader, org.apache.fop.apps.Driver.RENDER_PDF);

			byte[] bytes = byteOut.toByteArray();
			inputStream = new ByteArrayInputStream(bytes);

			byteOut.close();

			return inputStream;
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}
	}

	/**
	 * Inicializa la transformacion a PDF.
	 * 
	 *  xslFichero
	 *            String
	 *  Transformer
	 *
	 * @param xslFichero the xsl fichero
	 * @return the transformer
	 * @throws AB04BException the AB 04 B exception
	 */
	private Transformer pdfTransformacionInit(String xslFichero)
			throws AB04BException {
		try {

			TransformerFactory tFactory = TransformerFactory.newInstance();
			// org.apache.fop.configuration.Configuration.put("baseDir", "c:/");
			return tFactory.newTransformer(new StreamSource(xslFichero));
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}
	}

	/**
	 * Ejecuta la transformación PDF.
	 * 
	 *  transformer
	 *            transformer
	 *  strReader
	 *            strReader
	 *  renderer
	 *            renderer
	 *  ByteArrayOutputStream
	 *
	 * @param transformer the transformer
	 * @param strReader the str reader
	 * @param renderer the renderer
	 * @return the byte array output stream
	 * @throws AB04BException the AB 04 B exception
	 */
	private ByteArrayOutputStream pdfTransformacionExec(
			Transformer transformer, StringReader strReader, int renderer)
			throws AB04BException {
		try {

			DOMResult domResultado = new DOMResult();

			transformer.transform(new StreamSource(strReader), domResultado);

			org.apache.fop.apps.Driver driver = new org.apache.fop.apps.Driver();

			driver.setRenderer(renderer);

			ByteArrayOutputStream byteOut = new ByteArrayOutputStream();

			driver.setOutputStream(byteOut);
			driver.render((org.w3c.dom.Document) domResultado.getNode());
			driver.reset();

			return byteOut;
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}
	}

	/**
	 * Obtiene los datos y genera el XML.
	 * 
	 *  vdocOs6
	 *            SdocOs6
	 *  StringBuffer
	 *
	 * @param vdocOs6 the vdoc os 6
	 * @return the xml
	 * @throws AB04BException the AB 04 B exception
	 */
	private StringBuffer getXml(VdocOs6 vdocOs6) throws AB04BException {
		try {
			StringBuffer xml = new StringBuffer();
			xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
			xml.append("<docOS6>");

			xml.append(obtenerDatosEmpresaCentro(vdocOs6));

			xml.append(obtenerDatosModalidadPreventiva(vdocOs6));

			xml.append("<codMer>");
			xml.append((vdocOs6.getCodmer() != null) ? vdocOs6.getCodmer() : "");
			xml.append("</codMer>");
			xml.append("<inderSi>");
			xml.append((vdocOs6.getIndersi() != null) ? vdocOs6.getIndersi()
					: "");
			xml.append("</inderSi>");
			xml.append("<inderNo>");
			xml.append((vdocOs6.getInderno() != null) ? vdocOs6.getInderno()
					: "");
			xml.append("</inderNo>");
			xml.append("<rieEmp>");
			xml.append((vdocOs6.getRieemp() != null) ? vdocOs6.getRieemp() : "");
			xml.append("</rieEmp>");
			xml.append("<rieTra>");
			xml.append((vdocOs6.getRietra() != null) ? vdocOs6.getRietra() : "");
			xml.append("</rieTra>");
			xml.append("<rieSpp>");
			xml.append((vdocOs6.getRiespp() != null) ? vdocOs6.getRiespp() : "");
			xml.append("</rieSpp>");
			xml.append("<rieOtro>");
			xml.append((vdocOs6.getRieotro() != null) ? vdocOs6.getRieotro()
					: "");
			xml.append("</rieOtro>");
			xml.append("<rieSpa>");
			xml.append((vdocOs6.getRiespa() != null) ? vdocOs6.getRiespa() : "");
			xml.append("</rieSpa>");
			xml.append("<desOtro>");
			xml.append((vdocOs6.getDesotro() != null) ? vdocOs6.getDesotro()
					: "");
			xml.append("</desOtro>");
			xml.append("<firmSi>");
			xml.append((vdocOs6.getFirmsi() != null) ? vdocOs6.getFirmsi() : "");
			xml.append("</firmSi>");
			xml.append("<firmNo>");
			xml.append((vdocOs6.getFirmno() != null) ? vdocOs6.getFirmno() : "");
			xml.append("</firmNo>");
			xml.append("<parDeleSi>");
			xml.append((vdocOs6.getPardelesi() != null) ? vdocOs6
					.getPardelesi() : "");
			xml.append("</parDeleSi>");
			xml.append("<parDeleNo>");
			xml.append((vdocOs6.getPardeleno() != null) ? vdocOs6
					.getPardeleno() : "");
			xml.append("</parDeleNo>");
			xml.append("<parTraSi>");
			xml.append((vdocOs6.getPartrasi() != null) ? vdocOs6.getPartrasi()
					: "");
			xml.append("</parTraSi>");
			xml.append("<parTraNo>");
			xml.append((vdocOs6.getPartrano() != null) ? vdocOs6.getPartrano()
					: "");
			xml.append("</parTraNo>");
			xml.append("<conDeleSi>");
			xml.append((vdocOs6.getCondelesi() != null) ? vdocOs6
					.getCondelesi() : "");
			xml.append("</conDeleSi>");
			xml.append("<conDeleNo>");
			xml.append((vdocOs6.getCondeleno() != null) ? vdocOs6
					.getCondeleno() : "");
			xml.append("</conDeleNo>");
			xml.append("<infTraSi>");
			xml.append((vdocOs6.getInftrasi() != null) ? vdocOs6.getInftrasi()
					: "");
			xml.append("</infTraSi>");
			xml.append("<infTraNo>");
			xml.append((vdocOs6.getInftrano() != null) ? vdocOs6.getInftrano()
					: "");
			xml.append("</infTraNo>");
			xml.append("<medPlaSi>");
			xml.append((vdocOs6.getMedplasi() != null) ? vdocOs6.getMedplasi()
					: "");
			xml.append("</medPlaSi>");
			xml.append("<medPlaNo>");
			xml.append((vdocOs6.getMedplano() != null) ? vdocOs6.getMedplano()
					: "");
			xml.append("</medPlaNo>");
			xml.append("<medResSi>");
			xml.append((vdocOs6.getMedressi() != null) ? vdocOs6.getMedressi()
					: "");
			xml.append("</medResSi>");
			xml.append("<medResNo>");
			xml.append((vdocOs6.getMedresno() != null) ? vdocOs6.getMedresno()
					: "");
			xml.append("</medResNo>");
			xml.append("<medFecSi>");
			xml.append((vdocOs6.getMedfecsi() != null) ? vdocOs6.getMedfecsi()
					: "");
			xml.append("</medFecSi>");
			xml.append("<medFecNo>");
			xml.append((vdocOs6.getMedfecno() != null) ? vdocOs6.getMedfecno()
					: "");
			xml.append("</medFecNo>");
			xml.append("<medPreSi>");
			xml.append((vdocOs6.getMedpresi() != null) ? vdocOs6.getMedpresi()
					: "");
			xml.append("</medPreSi>");
			xml.append("<medPreNo>");
			xml.append((vdocOs6.getMedpreno() != null) ? vdocOs6.getMedpreno()
					: "");
			xml.append("</medPreNo>");
			xml.append("<codMed>");
			xml.append((vdocOs6.getCodmed() != null) ? vdocOs6.getCodmed() : "");
			xml.append("</codMed>");
			xml.append("<medPlaActSi>");
			xml.append((vdocOs6.getMedplaactsi() != null) ? vdocOs6
					.getMedplaactsi() : "");
			xml.append("</medPlaActSi>");
			xml.append("<medPlaActNo>");
			xml.append((vdocOs6.getMedplaactno() != null) ? vdocOs6
					.getMedplaactno() : "");
			xml.append("</medPlaActNo>");
			xml.append("<conPlaTraSi>");
			xml.append((vdocOs6.getConplatrasi() != null) ? vdocOs6
					.getConplatrasi() : "");
			xml.append("</conPlaTraSi>");
			xml.append("<conPlaTraNo>");
			xml.append((vdocOs6.getConplatrano() != null) ? vdocOs6
					.getConplatrano() : "");
			xml.append("</conPlaTraNo>");
			xml.append("<medSimuSi>");
			xml.append((vdocOs6.getMedsimusi() != null) ? vdocOs6
					.getMedsimusi() : "");
			xml.append("</medSimuSi>");
			xml.append("<medSimuNo>");
			xml.append((vdocOs6.getMedsimuno() != null) ? vdocOs6
					.getMedsimuno() : "");
			xml.append("</medSimuNo>");
			xml.append("<rmeEmp>");
			xml.append((vdocOs6.getRmeemp() != null) ? vdocOs6.getRmeemp() : "");
			xml.append("</rmeEmp>");
			xml.append("<rmeTra>");
			xml.append((vdocOs6.getRmetra() != null) ? vdocOs6.getRmetra() : "");
			xml.append("</rmeTra>");
			xml.append("<rmeSpp>");
			xml.append((vdocOs6.getRmespp() != null) ? vdocOs6.getRmespp() : "");
			xml.append("</rmeSpp>");
			xml.append("<rmeOtro>");
			xml.append((vdocOs6.getRmeotro() != null) ? vdocOs6.getRmeotro()
					: "");
			xml.append("</rmeOtro>");
			xml.append("<rmeSpa>");
			xml.append((vdocOs6.getRmespa() != null) ? vdocOs6.getRmespa() : "");
			xml.append("</rmeSpa>");
			xml.append("<desOtro2>");
			xml.append((vdocOs6.getDesotro2() != null) ? vdocOs6.getDesotro2()
					: "");
			xml.append("</desOtro2>");
			xml.append("<forTraPre>");
			xml.append((vdocOs6.getFortrapre() != null) ? vdocOs6
					.getFortrapre() : "");
			xml.append("</forTraPre>");
			xml.append("<vigSal>");
			xml.append((vdocOs6.getVigsal() != null) ? vdocOs6.getVigsal() : "");
			xml.append("</vigSal>");
			xml.append("<traSen>");
			xml.append((vdocOs6.getTrasen() != null) ? vdocOs6.getTrasen() : "");
			xml.append("</traSen>");
			xml.append("<traMen>");
			xml.append((vdocOs6.getTramen() != null) ? vdocOs6.getTramen() : "");
			xml.append("</traMen>");
			xml.append("<traMat>");
			xml.append((vdocOs6.getTramat() != null) ? vdocOs6.getTramat() : "");
			xml.append("</traMat>");
			xml.append("<infNueSi>");
			xml.append((vdocOs6.getInfnuesi() != null) ? vdocOs6.getInfnuesi()
					: "");
			xml.append("</infNueSi>");
			xml.append("<infNueNo>");
			xml.append((vdocOs6.getInfnueno() != null) ? vdocOs6.getInfnueno()
					: "");
			xml.append("</infNueNo>");
			xml.append("<planAcogSi>");
			xml.append((vdocOs6.getPlanacogsi() != null) ? vdocOs6
					.getPlanacogsi() : "");
			xml.append("</planAcogSi>");
			xml.append("<planAcogNo>");
			xml.append((vdocOs6.getPlanacogno() != null) ? vdocOs6
					.getPlanacogno() : "");
			xml.append("</planAcogNo>");
			xml.append("<observaciones>");
			xml.append((vdocOs6.getObservaciones() != null) ? vdocOs6
					.getObservaciones() : "");
			xml.append("</observaciones>");
			xml.append("</docOS6>");
			return xml;
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}
	}

	/**
	 * Obtiene los datos de la empresa y el centro y lo develve en formato XML.
	 * 
	 *  vdocOs6
	 *            SdocOs6
	 *  String
	 *
	 * @param vdocOs6 the vdoc os 6
	 * @return the string
	 */
	private String obtenerDatosEmpresaCentro(VdocOs6 vdocOs6) {
		StringBuffer xml = new StringBuffer();
		xml.append("<numExp>");
		xml.append((vdocOs6.getNumexp() != null) ? vdocOs6.getNumexp() : "");
		xml.append("</numExp>");
		xml.append("<numVis>");
		xml.append((vdocOs6.getNumvis() != null) ? vdocOs6.getNumvis() : "");
		xml.append("</numVis>");
		xml.append("<nomTec>");
		xml.append((vdocOs6.getNomtec() != null) ? vdocOs6.getNomtec() : "");
		xml.append("</nomTec>");
		xml.append("<codTec>");
		xml.append((vdocOs6.getCodtec() != null) ? vdocOs6.getCodtec() : "");
		xml.append("</codTec>");
		xml.append("<fechaVis>");
		xml.append((vdocOs6.getFechavis() != null) ? vdocOs6.getFechavis() : "");
		xml.append("</fechaVis>");
		xml.append("<fechaRevi>");
		xml.append((vdocOs6.getFecharevi() != null) ? vdocOs6.getFecharevi()
				: "");
		xml.append("</fechaRevi>");
		xml.append("<nomEmpresa>");
		xml.append((vdocOs6.getNomempresa() != null) ? vdocOs6.getNomempresa()
				: "");
		xml.append("</nomEmpresa>");
		xml.append("<nifEmpresa>");
		xml.append((vdocOs6.getNifempresa() != null) ? vdocOs6.getNifempresa()
				: "");
		xml.append("</nifEmpresa>");
		xml.append("<provSSEmp>");
		xml.append((vdocOs6.getProvssemp() != null) ? vdocOs6.getProvssemp()
				: "");
		xml.append("</provSSEmp>");
		xml.append("<numSSEmp>");
		xml.append((vdocOs6.getNumssemp() != null) ? vdocOs6.getNumssemp() : "");
		xml.append("</numSSEmp>");
		xml.append("<digSSEmp>");
		xml.append((vdocOs6.getDigssemp() != null) ? vdocOs6.getDigssemp() : "");
		xml.append("</digSSEmp>");
		xml.append("<domicilioEmp>");
		xml.append((vdocOs6.getDomicilioemp() != null) ? vdocOs6
				.getDomicilioemp() : "");
		xml.append("</domicilioEmp>");
		xml.append("<codPostalEmp>");
		xml.append((vdocOs6.getCodpostalemp() != null) ? vdocOs6
				.getCodpostalemp() : "");
		xml.append("</codPostalEmp>");
		xml.append("<cnaeEmp>");
		xml.append((vdocOs6.getCnaeemp() != null) ? vdocOs6.getCnaeemp() : "");
		xml.append("</cnaeEmp>");
		xml.append("<tipAperSi>");
		xml.append((vdocOs6.getTipapersi() != null) ? vdocOs6.getTipapersi()
				: "");
		xml.append("</tipAperSi>");
		xml.append("<tipAperNo>");
		xml.append((vdocOs6.getTipaperno() != null) ? vdocOs6.getTipaperno()
				: "");
		xml.append("</tipAperNo>");
		xml.append("<numTra>");
		xml.append((vdocOs6.getNumtra() != null) ? vdocOs6.getNumtra() : "");
		xml.append("</numTra>");
		xml.append("<domicilioCen>");
		xml.append((vdocOs6.getDomiciliocen() != null) ? vdocOs6
				.getDomiciliocen() : "");
		xml.append("</domicilioCen>");
		xml.append("<codPostalCen>");
		xml.append((vdocOs6.getCodpostalcen() != null) ? vdocOs6
				.getCodpostalcen() : "");
		xml.append("</codPostalCen>");
		xml.append("<telCen>");
		xml.append((vdocOs6.getTelcen() != null) ? vdocOs6.getTelcen() : "");
		xml.append("</telCen>");
		xml.append("<faxCen>");
		xml.append((vdocOs6.getFaxcen() != null) ? vdocOs6.getFaxcen() : "");
		xml.append("</faxCen>");
		xml.append("<emailCen>");
		xml.append((vdocOs6.getEmailcen() != null) ? vdocOs6.getEmailcen() : "");
		xml.append("</emailCen>");
		return xml.toString();
	}

	/**
	 * Obtiene los datos de la modalidad preventiva y lo develve en formato XML.
	 * 
	 *  vdocOs6
	 *            SdocOs6
	 *  String
	 *
	 * @param vdocOs6 the vdoc os 6
	 * @return the string
	 */
	private String obtenerDatosModalidadPreventiva(VdocOs6 vdocOs6) {
		StringBuffer xml = new StringBuffer();
		xml.append("<codMod>");
		xml.append((vdocOs6.getCodmod() != null) ? vdocOs6.getCodmod() : "");
		xml.append("</codMod>");
		xml.append("<mopEmp>");
		xml.append((vdocOs6.getMopemp() != null) ? vdocOs6.getMopemp() : "");
		xml.append("</mopEmp>");
		xml.append("<forEmpSi>");
		xml.append((vdocOs6.getForempsi() != null) ? vdocOs6.getForempsi() : "");
		xml.append("</forEmpSi>");
		xml.append("<forEmpSiB>");
		xml.append((vdocOs6.getForempsib() != null) ? vdocOs6.getForempsib()
				: "");
		xml.append("</forEmpSiB>");
		xml.append("<forEmpSiI>");
		xml.append((vdocOs6.getForempsii() != null) ? vdocOs6.getForempsii()
				: "");
		xml.append("</forEmpSiI>");
		xml.append("<forEmpSiS>");
		xml.append((vdocOs6.getForempsis() != null) ? vdocOs6.getForempsis()
				: "");
		xml.append("</forEmpSiS>");
		xml.append("<forEmpNo>");
		xml.append((vdocOs6.getForempno() != null) ? vdocOs6.getForempno() : "");
		xml.append("</forEmpNo>");
		xml.append("<mopTra>");
		xml.append((vdocOs6.getMoptra() != null) ? vdocOs6.getMoptra() : "");
		xml.append("</mopTra>");
		xml.append("<numTraMop>");
		xml.append((vdocOs6.getNumtramop() != null) ? vdocOs6.getNumtramop()
				: "");
		xml.append("</numTraMop>");
		xml.append("<forTraSi>");
		xml.append((vdocOs6.getFortrasi() != null) ? vdocOs6.getFortrasi() : "");
		xml.append("</forTraSi>");
		xml.append("<numTraSi>");
		xml.append((vdocOs6.getNumtra() != null) ? vdocOs6.getNumtra() : "");
		xml.append("</numTraSi>");
		xml.append("<forTraSiB>");
		xml.append((vdocOs6.getFortrasib() != null) ? vdocOs6.getFortrasib()
				: "");
		xml.append("</forTraSiB>");
		xml.append("<forTraSiI>");
		xml.append((vdocOs6.getFortrasii() != null) ? vdocOs6.getFortrasii()
				: "");
		xml.append("</forTraSiI>");
		xml.append("<forTraSiS>");
		xml.append((vdocOs6.getFortrasis() != null) ? vdocOs6.getFortrasis()
				: "");
		xml.append("</forTraSiS>");
		xml.append("<forTraNo>");
		xml.append((vdocOs6.getFortrano() != null) ? vdocOs6.getFortrano() : "");
		xml.append("</forTraNo>");
		xml.append("<numTraNo>");
		xml.append((vdocOs6.getNumtrano() != null) ? vdocOs6.getNumtrano() : "");
		xml.append("</numTraNo>");
		xml.append("<mopSpp>");
		xml.append((vdocOs6.getMopspp() != null) ? vdocOs6.getMopspp() : "");
		xml.append("</mopSpp>");
		xml.append("<segSpp>");
		xml.append((vdocOs6.getSegspp() != null) ? vdocOs6.getSegspp() : "");
		xml.append("</segSpp>");
		xml.append("<higSpp>");
		xml.append((vdocOs6.getHigspp() != null) ? vdocOs6.getHigspp() : "");
		xml.append("</higSpp>");
		xml.append("<ergSpp>");
		xml.append((vdocOs6.getErgspp() != null) ? vdocOs6.getErgspp() : "");
		xml.append("</ergSpp>");
		xml.append("<medSpp>");
		xml.append((vdocOs6.getMedspp() != null) ? vdocOs6.getMedspp() : "");
		xml.append("</medSpp>");
		xml.append("<mopSpa>");
		xml.append((vdocOs6.getMopspa() != null) ? vdocOs6.getMopspa() : "");
		xml.append("</mopSpa>");
		xml.append("<segSpa>");
		xml.append((vdocOs6.getSegspa() != null) ? vdocOs6.getSegspa() : "");
		xml.append("</segSpa>");
		xml.append("<higSpa>");
		xml.append((vdocOs6.getHigspa() != null) ? vdocOs6.getHigspa() : "");
		xml.append("</higSpa>");
		xml.append("<ergSpa>");
		xml.append((vdocOs6.getErgspa() != null) ? vdocOs6.getErgspa() : "");
		xml.append("</ergSpa>");
		xml.append("<medSpa>");
		xml.append((vdocOs6.getMedspa() != null) ? vdocOs6.getMedspa() : "");
		xml.append("</medSpa>");
		xml.append("<nomSpa>");
		xml.append((vdocOs6.getNomspa() != null) ? vdocOs6.getNomspa() : "");
		xml.append("</nomSpa>");
		xml.append("<comSeg>");
		xml.append((vdocOs6.getComseg() != null) ? vdocOs6.getComseg() : "");
		xml.append("</comSeg>");
		xml.append("<numComSeg1>");
		xml.append((vdocOs6.getNumcomseg1() != null) ? vdocOs6.getNumcomseg1()
				: "");
		xml.append("</numComSeg1>");
		xml.append("<numComSeg2>");
		xml.append((vdocOs6.getNumcomseg2() != null) ? vdocOs6.getNumcomseg2()
				: "");
		xml.append("</numComSeg2>");
		xml.append("<delPre>");
		xml.append((vdocOs6.getDelpre() != null) ? vdocOs6.getDelpre() : "");
		xml.append("</delPre>");
		xml.append("<numDel>");
		xml.append((vdocOs6.getNumdel() != null) ? vdocOs6.getNumdel() : "");
		xml.append("</numDel>");
		xml.append("<forPreSi>");
		xml.append((vdocOs6.getForpresi() != null) ? vdocOs6.getForpresi() : "");
		xml.append("</forPreSi>");
		xml.append("<numDefSi>");
		xml.append((vdocOs6.getNumdefsi() != null) ? vdocOs6.getNumdefsi() : "");
		xml.append("</numDefSi>");
		xml.append("<forPreNo>");
		xml.append((vdocOs6.getForpreno() != null) ? vdocOs6.getForpreno() : "");
		xml.append("</forPreNo>");
		xml.append("<numDefNo>");
		xml.append((vdocOs6.getNumdefno() != null) ? vdocOs6.getNumdefno() : "");
		xml.append("</numDefNo>");
		return xml.toString();
	}
}
